
import SwiftUI

nonisolated final class Product: Sendable {
   let name: String

   init(name: String) {
      self.name = name
   }
}
actor ItemData {
   var stock: Int = 100

   func sellProduct(product: Product, quantity: Int) {
      stock = stock - quantity
      print("Stock: \(stock) \(product.name)")
   }
}
struct ContentView: View {
   var item: ItemData = ItemData()

   var body: some View {
      Button("Run Task") {
         Task {
            let product = Product(name: "Lamp")
            await showStock(product: product)
         }
      }
   }
   @concurrent
   func showStock(product: Product) async {
      await item.sellProduct(product: product, quantity: 5)
   }
}

#Preview {
    ContentView()
}
